/* ============ */
/* ehead.h	*/
/* ============ */
/* ==================================================================== */
/*	INCLUDE FILE FOR EXTENDED PRECISION ARITHMETIC PROGRAMS		*/
/* ==================================================================== */

# if defined(__EHEAD_H__)
#	/* Do Nothing */
# else
#	define	__EHEAD_H__

/* Number of 16 bit words in external x type format */
#define NE 10

/* Number of 16 bit words in internal format */
#define NI (NE+3)

/* Array offset to exponent */
#define E 1

/* Array offset to high guard word */
#define M 2

/* Number of bits of precision */
#define NBITS ((NI-4)*16)

/* Maximum number of decimal digits in ASCII conversion
 * = NBITS*log10(2)
 */
#define NDEC (NBITS*8/27)

/* The exponent of 1.0 */
#define EXONE (0x3fff)

#define	E32     e32
#define	EEUL   	eeul
#define	EHALF  	ehalf
#define	ELOG2  	elog2
#define	EONE   	eone
#define	EONEOPI	eoneopi
#define	EPI    	epi
#define	ESQRT2 	esqrt2
#define	ETWO   	etwo
#define	EZERO  	ezero

extern unsigned short e32[];
extern unsigned short eeul[];
extern unsigned short ehalf[];
extern unsigned short elog2[];
extern unsigned short eone[];
extern unsigned short eoneopi[];
extern unsigned short epi[];
extern unsigned short esqrt2[];
extern unsigned short etwo[];
extern unsigned short ezero[];

/* by Stephen L. Moshier. */
# endif					/* ehead.h */
